window.onload = function() {
    var map = L.map('map').setView([12.3711, -1.5197], 13);
    var destinationMarker; // Marqueur pour la destination
    var sourceMarker; // Marqueur pour le point de départ

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors',
        minZoom: 1,
        maxZoom: 20
    }).addTo(map);

    var control = L.Routing.control({
        lineOptions: {
            styles: [{ color: '#839c49', opacity: 1, weight: 7 }]
        },
        router: new L.Routing.osrmv1({
            language: 'fr',
            profile: 'car'
        }),
        waypoints: [],
        createMarker: function(i, waypoint, n) {
            var marker = L.marker(waypoint.latLng, { draggable: true })
                .bindPopup(i === 0 ? "Point de départ" : "Point d'arrivée")
                .on('dragend', function(e) {
                    var newLatLng = e.target.getLatLng();
                    control.spliceWaypoints(i, 1, newLatLng);
                    updateMarkers(); // Met à jour les marqueurs sur la carte
                });
            return marker;
        },
        routeWhileDragging: true,
        show: false,
        draggableWaypoints: true
    }).addTo(map);

    function updateMarkers() {
        // Met à jour les marqueurs pour qu'ils soient alignés avec les waypoints
        if (sourceMarker) {
            var sourceLatLng = control.getWaypoints()[0].latLng;
            sourceMarker.setLatLng(sourceLatLng);
        }
        if (destinationMarker) {
            var destinationLatLng = control.getWaypoints()[1].latLng;
            destinationMarker.setLatLng(destinationLatLng);
        }
    }

    // Initialisation de l'ajout de destination sur la carte
    initialiserAjoutDestination(map, control);
    initialiserSuppressionPoint(control);

    // Fonction pour afficher les suggestions
    function afficherSuggestions(input, containerSuggestions, inputElement) {
        if (input.length < 2) {
            containerSuggestions.innerHTML = '';
            return;
        }

        var url = `https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(input)}&countrycodes=BF&accept-language=fr&addressdetails=1&limit=50`;

        fetch(url)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erreur réseau : ' + response.statusText);
                }
                return response.json();
            })
            .then(data => {
                console.log(data);
                containerSuggestions.innerHTML = '';
                if (data.length > 0) {
                    data.forEach(result => {
                        var suggestion = document.createElement('div');
                        suggestion.className = 'suggestion';
                        suggestion.textContent = result.display_name;
                        suggestion.onclick = function() {
                            inputElement.value = result.display_name;
                            var destinationLatLng = [result.lat, result.lon];

                            // Ajouter ou mettre à jour le marqueur
                            if (inputElement === document.getElementById('source-search')) {
                                if (sourceMarker) {
                                    map.removeLayer(sourceMarker);
                                }
                                sourceMarker = L.marker(destinationLatLng, { draggable: true })
                                    .addTo(map)
                                    .bindPopup("Point de départ")
                                    .openPopup()
                                    .on('dragend', function(e) {
                                        var newLatLng = e.target.getLatLng();
                                        control.spliceWaypoints(0, 1, newLatLng);
                                        updateMarkers(); // Met à jour les marqueurs sur la carte
                                    });
                            } else {
                                if (destinationMarker) {
                                    map.removeLayer(destinationMarker);
                                }
                                destinationMarker = L.marker(destinationLatLng, { draggable: true })
                                    .addTo(map)
                                    .bindPopup("Point d'arrivée")
                                    .openPopup()
                                    .on('dragend', function(e) {
                                        var newLatLng = e.target.getLatLng();
                                        control.spliceWaypoints(1, 1, newLatLng);
                                        updateMarkers(); // Met à jour les marqueurs sur la carte
                                    });
                            }
                            containerSuggestions.innerHTML = '';
                            // Déclenche automatiquement l'itinéraire après avoir sélectionné les points
                            definirItineraireAutomatique();
                        };
                        containerSuggestions.appendChild(suggestion);
                    });
                }
            })
            .catch(error => {
                console.error("Erreur lors de la récupération des suggestions : ", error);
            });
    }

    // Écouteurs pour les champs de recherche
    document.getElementById('source-search').addEventListener('input', function() {
        var input = this.value;
        var containerSuggestions = document.getElementById('source-suggestions');
        afficherSuggestions(input, containerSuggestions, this);
    });

    document.getElementById('destination-search').addEventListener('input', function() {
        var input = this.value;
        var containerSuggestions = document.getElementById('destination-suggestions');
        afficherSuggestions(input, containerSuggestions, this);
    });

    // Fonction pour définir automatiquement l'itinéraire sans bouton
    function definirItineraireAutomatique() {
        var sourceQuery = document.getElementById('source-search').value;
        var destinationQuery = document.getElementById('destination-search').value;

        if (sourceQuery && destinationQuery) {
            fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(sourceQuery)}&countrycodes=BF`)
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        var sourceLatLng = [data[0].lat, data[0].lon];
                        fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(destinationQuery)}&countrycodes=BF`)
                            .then(response => response.json())
                            .then(data => {
                                if (data.length > 0) {
                                    var destinationLatLng = [data[0].lat, data[0].lon];
                                    control.setWaypoints([sourceLatLng, destinationLatLng]);
                                    
                                    // Ajouter les marqueurs
                                    if (sourceMarker) {
                                        map.removeLayer(sourceMarker);
                                    }
                                    sourceMarker = L.marker(sourceLatLng, { draggable: true })
                                        .addTo(map)
                                        .bindPopup("Point de départ")
                                        .on('dragend', function(e) {
                                            var newLatLng = e.target.getLatLng();
                                            control.spliceWaypoints(0, 1, newLatLng);
                                            updateMarkers(); // Met à jour les marqueurs sur la carte
                                        });

                                    if (destinationMarker) {
                                        map.removeLayer(destinationMarker);
                                    }
                                    destinationMarker = L.marker(destinationLatLng, { draggable: true })
                                        .addTo(map)
                                        .bindPopup("Point d'arrivée")
                                        .on('dragend', function(e) {
                                            var newLatLng = e.target.getLatLng();
                                            control.spliceWaypoints(1, 1, newLatLng);
                                            updateMarkers(); // Met à jour les marqueurs sur la carte
                                        });

                                    map.setView(sourceLatLng, 9);
                                } else {
                                   // alert("Destination d'arrivée non trouvée, veuillez entrer une destination correcte.");
                                }
                            });
                    } else {
                       // alert("Destination de départ non trouvée, veuillez entrer une destination correcte.");
                    }
                });
        } else {
           // alert('Veuillez entrer à la fois une destination de départ et une destination d\'arrivée.');
        }
    }/*
    // Gérer l'ajout d'un point supplémentaire
document.getElementById('add-waypoint-btn').addEventListener('click', function() {
    var newWaypointDiv = document.createElement('div');
    newWaypointDiv.classList.add('input-group');

    // Créer un nouveau champ pour une destination supplémentaire
    var newWaypointInput = document.createElement('input');
    newWaypointInput.type = 'text';
    newWaypointInput.placeholder = 'Nouvelle destination';
    newWaypointInput.classList.add('waypoint-input');

    // Ajouter la div pour les suggestions dynamiques
    var newSuggestionsDiv = document.createElement('div');
    newSuggestionsDiv.classList.add('suggestions');

    // Ajouter les événements pour gérer les suggestions
    newWaypointInput.addEventListener('input', function() {
        var input = this.value;
        afficherSuggestions(input, newSuggestionsDiv, newWaypointInput);
    });

    // Ajouter le champ et les suggestions dans la div principale
    newWaypointDiv.appendChild(newWaypointInput);
    newWaypointDiv.appendChild(newSuggestionsDiv);
    document.getElementById('additional-waypoints').appendChild(newWaypointDiv);
});

// Stocker une référence au bouton
const addButton = document.getElementById('add-waypoint-btn');

// Événement pour ajouter un nouveau champ
addButton.addEventListener('click', function() {
    var newWaypointDiv = document.createElement('div');
    newWaypointDiv.classList.add('input-group');

    // Créer un nouveau champ pour une destination supplémentaire
    var newWaypointInput = document.createElement('input');
    newWaypointInput.type = 'text';
    newWaypointInput.placeholder = 'Nouvelle destination';
    newWaypointInput.classList.add('waypoint-input');

    // Ajouter la div pour les suggestions dynamiques
    var newSuggestionsDiv = document.createElement('div');
    newSuggestionsDiv.classList.add('suggestions');

    // Ajouter les événements pour gérer les suggestions
    newWaypointInput.addEventListener('input', function() {
        var input = this.value;
        afficherSuggestions(input, newSuggestionsDiv, newWaypointInput);
    });

    // Ajouter le champ et les suggestions dans la div principale
    newWaypointDiv.appendChild(newWaypointInput);
    newWaypointDiv.appendChild(newSuggestionsDiv);

    // Déplacer le bouton + dans la nouvelle div
    newWaypointDiv.appendChild(addButton);

    // Ajouter la div pour les waypoints supplémentaires
    document.getElementById('additional-waypoints').appendChild(newWaypointDiv);
});

document.getElementById('add-waypoint-btn').addEventListener('click', function() {
    var newWaypointDiv = document.createElement('div');
    newWaypointDiv.classList.add('input-group');

    var destinationContainer = document.createElement('div');
    destinationContainer.classList.add('destination-container');

    var newWaypointInput = document.createElement('input');
    newWaypointInput.type = 'text';
    newWaypointInput.placeholder = 'Nouvelle destination';
    newWaypointInput.classList.add('waypoint-input');

    var newSuggestionsDiv = document.createElement('div');
    newSuggestionsDiv.classList.add('suggestions');

    newWaypointInput.addEventListener('input', function() {
        var input = this.value;
        afficherSuggestions(input, newSuggestionsDiv, newWaypointInput);
    });

    var removeButton = document.createElement('span');
    removeButton.textContent = '✖';
    removeButton.classList.add('remove-waypoint-btn');
    removeButton.style.cursor = 'pointer';

    removeButton.addEventListener('click', function() {
        newWaypointDiv.remove();
        updateAddButtonPosition(); // Mettre à jour la position du bouton après suppression
    });

    destinationContainer.appendChild(newWaypointInput);
    destinationContainer.appendChild(removeButton);

    newWaypointDiv.appendChild(destinationContainer);
    newWaypointDiv.appendChild(newSuggestionsDiv);

    document.getElementById('additional-waypoints').appendChild(newWaypointDiv);

    // Mettre à jour la position du bouton +
    updateAddButtonPosition();
});

// Fonction pour mettre à jour la position du bouton +
function updateAddButtonPosition() {
    var waypointsDiv = document.getElementById('additional-waypoints');
    var addButton = document.getElementById('add-waypoint-btn');
    waypointsDiv.appendChild(addButton); // Déplacer le bouton à la fin
}
*
document.getElementById('add-waypoint-btn').addEventListener('click', function() {
    var newWaypointDiv = document.createElement('div');
    newWaypointDiv.classList.add('input-group');

    var destinationContainer = document.createElement('div');
    destinationContainer.classList.add('destination-container');

    var newWaypointInput = document.createElement('input');
    newWaypointInput.type = 'text';
    newWaypointInput.placeholder = 'Nouvelle destination';
    newWaypointInput.classList.add('waypoint-input');

    var newSuggestionsDiv = document.createElement('div');
    newSuggestionsDiv.classList.add('suggestions');

    newWaypointInput.addEventListener('input', function() {
        var input = this.value;
        afficherSuggestions(input, newSuggestionsDiv, newWaypointInput);
    });

    var removeButton = document.createElement('span');
    removeButton.textContent = '✖';
    removeButton.classList.add('remove-waypoint-btn');
    removeButton.style.cursor = 'pointer';

    removeButton.addEventListener('click', function() {
        newWaypointDiv.remove();
        updateAddButtonPosition(); // Mettre à jour la position du bouton après suppression
    });

    // Ajouter le champ d'entrée et le bouton de suppression dans le conteneur de destination
    destinationContainer.appendChild(newWaypointInput);
    destinationContainer.appendChild(removeButton);

    // Ajouter le conteneur de destination et les suggestions au conteneur principal
    newWaypointDiv.appendChild(destinationContainer);
    newWaypointDiv.appendChild(newSuggestionsDiv);

    // Ajouter le nouveau waypoint au conteneur principal
    document.getElementById('additional-waypoints').appendChild(newWaypointDiv);

    // Mettre à jour la position du bouton +
    updateAddButtonPosition();
});
*
let waypointCount = 0;

document.getElementById('add-waypoint-btn').addEventListener('click', function() {
    if (waypointCount < 4) {
        waypointCount++;
        var newWaypointDiv = document.createElement('div');
        newWaypointDiv.classList.add('input-group');

        var destinationContainer = document.createElement('div');
        destinationContainer.classList.add('destination-container');

        var newWaypointInput = document.createElement('input');
        newWaypointInput.type = 'text';
        newWaypointInput.placeholder = 'Nouvelle destination';
        newWaypointInput.classList.add('waypoint-input');

        var newSuggestionsDiv = document.createElement('div');
        newSuggestionsDiv.classList.add('suggestions');

        newWaypointInput.addEventListener('input', function() {
            var input = this.value;
            afficherSuggestions(input, newSuggestionsDiv, newWaypointInput);
        });

        var removeButton = document.createElement('span');
        removeButton.textContent = '✖';
        removeButton.classList.add('remove-waypoint-btn');
        removeButton.style.cursor = 'pointer';

        removeButton.addEventListener('click', function() {
            newWaypointDiv.remove();
            waypointCount--; // Décrémenter le compteur lors de la suppression
            updateAddButtonPosition(); // Mettre à jour la position du bouton après suppression
        });

        // Ajouter le champ d'entrée et le bouton de suppression dans le conteneur de destination
        destinationContainer.appendChild(newWaypointInput);
        destinationContainer.appendChild(removeButton);

        // Ajouter le conteneur de destination et les suggestions au conteneur principal
        newWaypointDiv.appendChild(destinationContainer);
        newWaypointDiv.appendChild(newSuggestionsDiv);

        // Ajouter le nouveau waypoint au conteneur principal
        document.getElementById('additional-waypoints').appendChild(newWaypointDiv);

        // Mettre à jour la position du bouton +
        updateAddButtonPosition();
    } else {
        alert("Bonne chance !");
    }
});

// Fonction pour mettre à jour la position du bouton +
function updateAddButtonPosition() {
    var waypointsDiv = document.getElementById('additional-waypoints');
    var addButton = document.getElementById('add-waypoint-btn');
    waypointsDiv.appendChild(addButton); // Déplacer le bouton à la fin
}
*/
let waypointCount = 0;

document.getElementById('add-waypoint-btn').addEventListener('click', function() {
    if (waypointCount < 4) {
        waypointCount++;
        var newWaypointDiv = document.createElement('div');
        newWaypointDiv.classList.add('input-group');

        var destinationContainer = document.createElement('div');
        destinationContainer.classList.add('destination-container');

        var newWaypointInput = document.createElement('input');
        newWaypointInput.type = 'text';
        newWaypointInput.placeholder = 'Nouvelle destination';
        newWaypointInput.classList.add('waypoint-input');

        var newSuggestionsDiv = document.createElement('div');
        newSuggestionsDiv.classList.add('suggestions');

        newWaypointInput.addEventListener('input', function() {
            var input = this.value;
            afficherSuggestions(input, newSuggestionsDiv, newWaypointInput);
        });

        var removeButton = document.createElement('span');
        removeButton.textContent = '✖';
        removeButton.classList.add('remove-waypoint-btn');
        removeButton.style.cursor = 'pointer';

        removeButton.addEventListener('click', function() {
            newWaypointDiv.remove();
            waypointCount--; // Décrémenter le compteur lors de la suppression
            toggleAddButtonVisibility(); // Vérifier la visibilité du bouton
        });

        // Ajouter le champ d'entrée et le bouton de suppression dans le conteneur de destination
        destinationContainer.appendChild(newWaypointInput);
        destinationContainer.appendChild(removeButton);

        // Ajouter le conteneur de destination et les suggestions au conteneur principal
        newWaypointDiv.appendChild(destinationContainer);
        newWaypointDiv.appendChild(newSuggestionsDiv);

        // Ajouter le nouveau waypoint au conteneur principal
        document.getElementById('additional-waypoints').appendChild(newWaypointDiv);

        // Vérifier la visibilité du bouton après ajout
        toggleAddButtonVisibility();
    } else {
        alert("Vous ne pouvez entrer que plus 4 destinations !");
    }
});

// Fonction pour gérer la visibilité du bouton +
function toggleAddButtonVisibility() {
    var addButton = document.getElementById('add-waypoint-btn');
    addButton.style.display = waypointCount >= 4 ? 'none' : 'block'; // Cacher ou montrer le bouton

    // Déplacer le bouton à la fin du conteneur
    var waypointsDiv = document.getElementById('additional-waypoints');
    waypointsDiv.appendChild(addButton);
}


// Ajouter les nouvelles waypoints à l'itinéraire
function definirItineraireAutomatique() {
    var sourceQuery = document.getElementById('source-search').value;
    var destinationQuery = document.getElementById('destination-search').value;

    if (sourceQuery && destinationQuery) {
        fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(sourceQuery)}&countrycodes=BF`)
            .then(response => response.json())
            .then(data => {
                if (data.length > 0) {
                    var sourceLatLng = [data[0].lat, data[0].lon];
                    fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(destinationQuery)}&countrycodes=BF`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.length > 0) {
                                var destinationLatLng = [data[0].lat, data[0].lon];
                                
                                // Collecter les waypoints supplémentaires
                                var additionalWaypoints = Array.from(document.getElementsByClassName('waypoint-input')).map(input => input.value);
                                var waypointPromises = additionalWaypoints.map(point => {
                                    return fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(point)}&countrycodes=BF`)
                                        .then(response => response.json());
                                });

                                // Gérer les waypoints supplémentaires
                                Promise.all(waypointPromises).then(results => {
                                    var waypoints = [sourceLatLng];
                                    results.forEach(result => {
                                        if (result.length > 0) {
                                            waypoints.push([result[0].lat, result[0].lon]);
                                        }
                                    });
                                    waypoints.push(destinationLatLng);

                                    // Définir les waypoints sur la carte
                                    control.setWaypoints(waypoints);

                                    // Ajouter les marqueurs
                                    if (sourceMarker) {
                                        map.removeLayer(sourceMarker);
                                    }
                                    sourceMarker = L.marker(sourceLatLng, { draggable: true })
                                        .addTo(map)
                                        .bindPopup("Point de départ")
                                        .on('dragend', function(e) {
                                            var newLatLng = e.target.getLatLng();
                                            control.spliceWaypoints(0, 1, newLatLng);
                                            updateMarkers(); // Met à jour les marqueurs sur la carte
                                        });

                                    if (destinationMarker) {
                                        map.removeLayer(destinationMarker);
                                    }
                                    destinationMarker = L.marker(destinationLatLng, { draggable: true })
                                        .addTo(map)
                                        .bindPopup("Point d'arrivée")
                                        .on('dragend', function(e) {
                                            var newLatLng = e.target.getLatLng();
                                            control.spliceWaypoints(waypoints.length - 1, 1, newLatLng);
                                            updateMarkers(); // Met à jour les marqueurs sur la carte
                                        });

                                    map.setView(sourceLatLng, 9);
                                });
                            } else {
                                alert("Destination d'arrivée non trouvée, veuillez entrer une destination correcte.");
                            }
                        });
                } else {
                    alert("Destination de départ non trouvée, veuillez entrer une destination correcte.");
                }
            });
    } else {
       // alert('Veuillez entrer à la fois une destination de départ et une destination d\'arrivée.');
    }
}

};
